// Encoding.cpp : implementation file
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "DriverSettings1.h"
#include "Encoding.h"
#include "afxdialogex.h"

//#############################################################################

#define TRACK1 0x01
#define TRACK2 0x02
#define TRACK3 0x04
#define ALL_TRACKS (TRACK1 + TRACK2 + TRACK3)

//#############################################################################

// CEncoding dialog

IMPLEMENT_DYNAMIC(CEncoding, CPropertyPage)

CEncoding::CEncoding()
	: CPropertyPage(CEncoding::IDD)
	, EncodingAction(0)
{
}

CEncoding::~CEncoding()
{
}

void CEncoding::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MAGSTRIPEBOX, MagMessage);
	DDX_Control(pDX, IDC_BTN_ENCODEMAGSTRIPE, EncodeMagBtn);
	DDX_Control(pDX, IDC_BTN_READMAGSTRIPE, ReadMagBtn);
	DDX_Control(pDX, IDC_ENCODING_COMBO, EncodingType);
	DDX_Control(pDX, IDC_COERCIVITY_COMBO, Coercivity);
	DDX_Control(pDX, IDC_VERIFY, Verify);
	DDX_Control(pDX, IDC_TRACK1_LABEL, Track1DataLabel);
	DDX_Control(pDX, IDC_TRACK1WRITE, Track1Write);
	DDX_Control(pDX, IDC_TRACK1DATA, Track1Data);
	DDX_Control(pDX, IDC_TRACK1READ, Track1Read);
	DDX_Control(pDX, IDC_TRACK1_SETTING, Track1SettingsLabel);
	DDX_Control(pDX, IDC_BPC_T1_COMBO, BPC_T1);
	DDX_Control(pDX, IDC_BPI_T1_COMBO, BPI_T1);
	DDX_Control(pDX, IDC_TRACK2_LABEL, Track2DataLabel);
	DDX_Control(pDX, IDC_TRACK2WRITE, Track2Write);
	DDX_Control(pDX, IDC_TRACK2DATA, Track2Data);
	DDX_Control(pDX, IDC_TRACK2READ, Track2Read);
	DDX_Control(pDX, IDC_TRACK2_SETTING, Track2SettingsLabel);
	DDX_Control(pDX, IDC_BPC_T2_COMBO, BPC_T2);
	DDX_Control(pDX, IDC_BPI_T2_COMBO, BPI_T2);
	DDX_Control(pDX, IDC_TRACK3_LABEL, Track3DataLabel);
	DDX_Control(pDX, IDC_TRACK3WRITE, Track3Write);
	DDX_Control(pDX, IDC_TRACK3DATA, Track3Data);
	DDX_Control(pDX, IDC_TRACK3READ, Track3Read);
	DDX_Control(pDX, IDC_TRACK3_SETTING, Track3SettingsLabel);
	DDX_Control(pDX, IDC_BPC_T3_COMBO, BPC_T3);
	DDX_Control(pDX, IDC_BPI_T3_COMBO, BPI_T3);
	DDX_Control(pDX, IDC_JIS2DATA_TEXT, JIS2DataLabel);
	DDX_Control(pDX, IDC_BITSPERCHAR_TEXT, BitsPerCharLabel);
	DDX_Control(pDX, IDC_BITSPERINCH_TEXT, BitsPerInchLabel);
	DDX_Control(pDX, IDC_STARTPOSN, StartPosition);
	DDX_Control(pDX, IDC_STARTPOSN_SPIN, StartPosition_Spin);
	DDX_Control(pDX, IDC_ENCODINGGETRADIO, EncodingGet);
	DDX_Control(pDX, IDC_ENCODINGSETRADIO, EncodingSet);
	DDX_Radio(pDX, IDC_ENCODINGGETRADIO, EncodingAction);
	DDV_MinMaxInt(pDX, EncodingAction, 0, 1);
	DDX_Control(pDX, IDC_BTN_READMAGTRACKS, ReadMagTracksBtn);
}

BEGIN_MESSAGE_MAP(CEncoding, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_ENCODEMAGSTRIPE, &CEncoding::OnBnClickedBtnEncodemagstripe)
	ON_BN_CLICKED(IDC_BTN_READMAGSTRIPE, &CEncoding::OnBnClickedBtnReadmagstripe)
	ON_BN_CLICKED(IDC_BTN_MAGSTRIPEBOX_CLR, &CEncoding::OnBnClickedBtnMagstripeboxClr)
	ON_CBN_SELCHANGE(IDC_ENCODING_COMBO, &CEncoding::OnCbnSelchangeEncodingtypeCombo)
	ON_BN_CLICKED(IDC_TRACK1WRITE, &CEncoding::OnBnClickedTrack1Write)
	ON_BN_CLICKED(IDC_TRACK2WRITE, &CEncoding::OnBnClickedTrack2Write)
	ON_BN_CLICKED(IDC_TRACK3WRITE, &CEncoding::OnBnClickedTrack3Write)
	ON_BN_CLICKED(IDC_BTN_MAGSTART, &CEncoding::OnBnClickedBtnMagstart)
	ON_BN_CLICKED(IDC_BTN_READMAGTRACKS, &CEncoding::OnBnClickedBtnReadmagtracks)
END_MESSAGE_MAP()

//#############################################################################

// CEncoding message handlers
BOOL CEncoding::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	Track1Data.SetWindowText(_T("THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG"));
	Track1Write.SetCheck(BST_CHECKED);

	Verify.SetCheck(TRUE);
	EncodingType.SetCurSel(0);
	Coercivity.SetCurSel(0);
	BPC_T1.SetCurSel(0);
	BPC_T2.SetCurSel(0);
	BPC_T3.SetCurSel(0);
	BPI_T1.SetCurSel(0);
	BPI_T2.SetCurSel(0);
	BPI_T3.SetCurSel(0);
	Track1Read.SetCheck(TRUE);
	Track2Read.SetCheck(TRUE);
	Track3Read.SetCheck(TRUE);

	//...Magnetic Encoding Start Position
	StartPosition_Spin.SetRange32(0, 85000);
	DWORD MagStart = 0;
	GetMagStart(&MagStart);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CEncoding::OnBnClickedTrack1Write()
{
	//Enable/Disable the appropriate controls according to the selection
	BOOL Control = (Track1Write.GetCheck() == BST_CHECKED);
	Track1DataLabel.EnableWindow(Control);
	Track1Data.EnableWindow(Control);
	Track1SettingsLabel.EnableWindow(Control);
	BPC_T1.EnableWindow(Control);
	BPI_T1.EnableWindow(Control);
}

void CEncoding::OnBnClickedTrack2Write()
{
	//Enable/Disable the appropriate controls according to the selection
	BOOL Control = (Track2Write.GetCheck() == BST_CHECKED);
	Track2DataLabel.EnableWindow(Control);
	Track2Data.EnableWindow(Control);
	Track2SettingsLabel.EnableWindow(Control);
	BPC_T2.EnableWindow(Control);
	BPI_T2.EnableWindow(Control);
}

void CEncoding::OnBnClickedTrack3Write()
{
	//Enable/Disable the appropriate controls according to the selection
	BOOL Control = (Track3Write.GetCheck() == BST_CHECKED);
	Track3DataLabel.EnableWindow(Control);
	Track3Data.EnableWindow(Control);
	Track3SettingsLabel.EnableWindow(Control);
	BPC_T3.EnableWindow(Control);
	BPI_T3.EnableWindow(Control);
}

//****************************************************************************

void CEncoding::OnCbnSelchangeEncodingtypeCombo()
{
	//Enable/Disable appropriate controls according to ISO or JIS2 being selected
	BOOL visible = (EncodingType.GetCurSel() == 0);		//TRUE if ISO, FALSE if JIS2

	Track1DataLabel.ShowWindow(visible);
	Track1Write.ShowWindow(visible);
	Track2DataLabel.ShowWindow(visible);
	Track2Data.ShowWindow(visible);
	Track2Write.ShowWindow(visible);
	Track3DataLabel.ShowWindow(visible);
	Track3Data.ShowWindow(visible);
	Track3Write.ShowWindow(visible);

	Track1SettingsLabel.ShowWindow(visible);
	BPC_T1.ShowWindow(visible);
	BPI_T1.ShowWindow(visible);
	Track2SettingsLabel.ShowWindow(visible);
	BPC_T2.ShowWindow(visible);
	BPI_T2.ShowWindow(visible);
	Track3SettingsLabel.ShowWindow(visible);
	BPC_T3.ShowWindow(visible);
	BPI_T3.ShowWindow(visible);
	BitsPerCharLabel.ShowWindow(visible);
	BitsPerInchLabel.ShowWindow(visible);
	JIS2DataLabel.ShowWindow(!visible);

	Track1Read.ShowWindow(visible);
	Track2Read.ShowWindow(visible);
	Track3Read.ShowWindow(visible);
	ReadMagTracksBtn.ShowWindow(visible);
}

//****************************************************************************

BOOL CEncoding::ActionIsGet()
{
	//Test the 'Action' radio buttons
	return (EncodingAction == 0);
}

void CEncoding::OnBnClickedBtnMagstripeboxClr()
{
	MagMessage.SetWindowText(_T(""));
}

void CEncoding::AddMagMessage(CString pMessage)
{
	Parent->AddString(&MagMessage, pMessage);
}

//****************************************************************************

#define ISO_TRACK1_START_SENTINEL       '%'
#define ISO_TRACK2_AND_3_START_SENTINEL ';'
#define ISO_END_SENTINEL                '?'
#define JIS2_SENTINEL                   '\x7f'

void CEncoding::OnBnClickedBtnEncodemagstripe()
{
	int SDKReturn;
	CWaitCursor wait;
	CString EncString;

	//Get SDK function address
	PFNIDENCODEMAG pFnEncodeMag = (PFNIDENCODEMAG)GetProcAddress(Parent->hLib, IDFN_ENCODEMAG);
	if (!pFnEncodeMag)
	{
		FUNCTION_NOT_ACCESSED(EncodeMag);
		return;
	}

	//Initialise common encoding parameters
	ID_MAGDEF MagDef;
	SecureZeroMemory(&MagDef, sizeof(MagDef));

	MagDef.iEncodingSpec = (ID_ENCODING)EncodingType.GetCurSel();
	MagDef.iVerify       = (Verify.GetCheck() == BST_CHECKED) ? ID_VERIFY_ON : ID_VERIFY_OFF;
	MagDef.iCoercivity   = (ID_COERCIVITY)Coercivity.GetCurSel();

	PID_MAGTRACK pMagTrack = &MagDef.Track[0];

	if (EncodingType.GetCurSel() == ID_ENCODING_JIS2)
	{
		//Get encoding string from control
		Track1Data.GetWindowText(EncString);
		CString temp = JIS2_SENTINEL + EncString + JIS2_SENTINEL;

		pMagTrack->lpszData   = new TCHAR[temp.GetLength() + 1];
		pMagTrack->iCharCount = temp.GetLength();
		_tcscpy_s(pMagTrack->lpszData, temp.GetLength() + 1, temp.GetString());
	}

	else
	{
		//ISO Track 1
		CString temp;
		if (Track1Write.GetCheck() == BST_CHECKED)
		{
			//Get encoding string from control
			Track1Data.GetWindowText(EncString);
			if (EncodingType.GetCurSel() == ID_ENCODING_ISO)
				temp = ISO_TRACK1_START_SENTINEL + EncString + ISO_END_SENTINEL;
			else
				temp = EncString; //Raw Data

			//Initialise for ISO Track 1 Encoding
			pMagTrack->lpszData   = new TCHAR[temp.GetLength() + 1];
			pMagTrack->iCharCount = temp.GetLength();
			_tcscpy_s(pMagTrack->lpszData, temp.GetLength() + 1, temp.GetString());

			pMagTrack->iBitsPerChar	= (ID_BITSPERCHAR)BPC_T1.GetCurSel();
			pMagTrack->iBitsPerInch	= (ID_BITSPERINCH)BPI_T1.GetCurSel();
		}

		//ISO Track 2
		if (Track2Write.GetCheck() == BST_CHECKED)
		{
			pMagTrack = &MagDef.Track[1];

			//Get encoding string from control
			Track2Data.GetWindowText(EncString);
			if (EncodingType.GetCurSel() == ID_ENCODING_ISO)
				temp = ISO_TRACK2_AND_3_START_SENTINEL + EncString + ISO_END_SENTINEL;
			else
				temp = EncString;

			//Initialise for ISO Track 2 Encoding
			pMagTrack->lpszData   = new TCHAR[temp.GetLength() + 1];
			pMagTrack->iCharCount = temp.GetLength();
			_tcscpy_s(pMagTrack->lpszData, temp.GetLength() + 1, temp.GetString());

			pMagTrack->iBitsPerChar	= (ID_BITSPERCHAR)BPC_T2.GetCurSel();
			pMagTrack->iBitsPerInch	= (ID_BITSPERINCH)BPI_T2.GetCurSel();
		}

		//ISO Track 3
		if (Track3Write.GetCheck() == BST_CHECKED)
		{
			pMagTrack = &MagDef.Track[2];

			//Get encoding string from control
			Track3Data.GetWindowText(EncString);
			if (EncodingType.GetCurSel() == ID_ENCODING_ISO)
				temp = ISO_TRACK2_AND_3_START_SENTINEL + EncString + ISO_END_SENTINEL;
			else
				temp = EncString;

			//Initialise for ISO Track 3 Encoding
			pMagTrack->lpszData   = new TCHAR[temp.GetLength() + 1];
			pMagTrack->iCharCount = temp.GetLength();
			_tcscpy_s(pMagTrack->lpszData, temp.GetLength() + 1, temp.GetString());

			pMagTrack->iBitsPerChar	= (ID_BITSPERCHAR)BPC_T3.GetCurSel();
			pMagTrack->iBitsPerInch	= (ID_BITSPERINCH)BPI_T3.GetCurSel();
		}
	}

	//Call SDK to perform the mag encoding
	SDKReturn = (*pFnEncodeMag)(Parent->hSession, &MagDef);
	if (SDKReturn != ID_SUCCESS)
	{
		DISPLAY_ERROR(EncodeMagStripe, SDKReturn);
	}
	else
	{
		//Wait for the printer to complete the encoding
		SDKReturn = Parent->WaitForPrinterToFinish();
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(EncodeMagStripeWait, SDKReturn);
		}
	}

	//Tidy up
	if (MagDef.Track[0].lpszData) delete[] MagDef.Track[0].lpszData;
	if (MagDef.Track[1].lpszData) delete[] MagDef.Track[1].lpszData;
	if (MagDef.Track[2].lpszData) delete[] MagDef.Track[2].lpszData;
}

//****************************************************************************

void CEncoding::DisplayUltimaMagData
(
	PID_MAGDATA2 MagData,
	int			 Tracks
)
{
	CString temp = CString(MagData->track[0].data, sizeof(MagData->track[0].data));

	//Output the data to the message box
	if (Tracks & TRACK1) 
		AddMagMessage(_T("(1): ") + temp);

	if ((ID_ENCODING)EncodingType.GetCurSel() == ID_ENCODING_ISO)
	{
		if (Tracks & TRACK2) 
			AddMagMessage(_T("(2): ") + CString(MagData->track[1].data, sizeof(MagData->track[1].data)));
		if (Tracks & TRACK3) 
			AddMagMessage(_T("(3): ") + CString(MagData->track[2].data, sizeof(MagData->track[2].data)));
	}
	AddMagMessage(_T(" "));
}

//****************************************************************************

void CEncoding::OnBnClickedBtnReadmagstripe()
{
	ID_MAGDATA2 MagData = {0};
	CWaitCursor wait;

	//Get SDK function address
	PFNIDREADMAG pFnReadMagStripe = (PFNIDREADMAG)GetProcAddress(Parent->hLib, "ID_ReadMag");
	if (!pFnReadMagStripe)
	{
		FUNCTION_NOT_ACCESSED(ReadMagStripe);
	}

	else
	{
		//Call SDK to read the Mag Stripe Data
		int SDKReturn = (*pFnReadMagStripe)(Parent->hSession, 
		                                    &MagData,
		                                    (ID_ENCODING)EncodingType.GetCurSel());
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(ReadMagStripe, SDKReturn);
		}

		else
		{
			DisplayUltimaMagData(&MagData, ALL_TRACKS);
		}
	}
}

//****************************************************************************

void CEncoding::OnBnClickedBtnReadmagtracks()
{
	ID_MAGDATA2 MagData = {0};
	CWaitCursor wait;

	//Get SDK function address
	PFNIDMAGTRACKS pFnReadMagTracks = (PFNIDMAGTRACKS)GetProcAddress(Parent->hLib, "ID_ReadMagTracks");
	if (!pFnReadMagTracks)
	{
		FUNCTION_NOT_ACCESSED(ReadMagTracks);
	}

	else
	{
		//Call SDK to read the Mag Stripe Data
		BYTE Tracks = 0;
		if (Track1Read.GetCheck() == BST_CHECKED) Tracks |= 1;
		if (Track2Read.GetCheck() == BST_CHECKED) Tracks |= 2;
		if (Track3Read.GetCheck() == BST_CHECKED) Tracks |= 4;

		if (Tracks == 0)
		{
			return;
		}

		int SDKReturn = (*pFnReadMagTracks)(Parent->hSession,
											&MagData, 
											(ID_ENCODING)EncodingType.GetCurSel(),
											Tracks);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(pFnReadMagTracks, SDKReturn);
		}

		else
		{
			DisplayUltimaMagData(&MagData, Tracks);
		}
	}
}

//****************************************************************************

ID_RETURN CEncoding::GetMagStart
(
	DWORD *pMagStart
)
{
	ID_RETURN result = ID_ERROR;

	PFNIDMAGSTART pFnMagStart = (PFNIDMAGSTART)GetProcAddress(Parent->hLib, "ID_MagStart");
	if (!pFnMagStart)
	{
		FUNCTION_NOT_ACCESSED(MagStart);
	}

	else
	{
		ID_RETURN SDKReturn = (*pFnMagStart)(Parent->hSession, ID_READ, pMagStart);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(MagStart, SDKReturn);
		}
		else
		{
			MagStartToControl(*pMagStart);
			result = ID_SUCCESS;
		}
	}

	return result;
}

//****************************************************************************

void CEncoding::MagStartToControl
(
	DWORD MagStart
)
{
	//Update the Start Position control
	CString temp_string;
	temp_string.Format(_T("%d"), MagStart);
	StartPosition.SetWindowText(temp_string);
}

//****************************************************************************

void CEncoding::MagStartToMsgBox
(
	DWORD        MagStart,
	ID_READWRITE Action
)
{
	//Update the message box with the Start Position setting
	CString temp_string;
	temp_string.Format(_T("%d"), MagStart);
	AddMagMessage(_T("MagStart") + Parent->Separator(Action) + temp_string);
	AddMagMessage(_T(""));
}

//****************************************************************************

void CEncoding::OnBnClickedBtnMagstart()
{
	CWaitCursor wait;
	DWORD MagStart = 0;

	if (ActionIsGet())
	{
		if (GetMagStart(&MagStart) == ID_SUCCESS)
		{
			MagStartToMsgBox(MagStart, ID_READ);
		}
	}
	else
	{
		//Call the SDK to write to the driver
		PFNIDMAGSTART pFnMagStart = (PFNIDMAGSTART)GetProcAddress(Parent->hLib, "ID_MagStart");
		if (!pFnMagStart)
		{
			FUNCTION_NOT_ACCESSED(MagStart);
		}

		else
		{
			//Get Mag Start setting from control
			CString temp_string;
			StartPosition.GetWindowText(temp_string);
			MagStart = (DWORD)_ttoi(temp_string);

			//Call the SDK to write to the driver
			int SDKReturn = (*pFnMagStart)(Parent->hSession, ID_WRITE, &MagStart);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetMagStart, SDKReturn);
			}
			else
			{
				MagStartToMsgBox(MagStart, ID_WRITE);
			}
		}
	}
}

